// Jasmine Unit Testing Suite
define([
    'backbone',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',
], function(Backbone, TimeSlotsCollection) {
    'use strict';

    describe('Time Slots Collection', function() {
        var collection;

        beforeEach(function() {
            collection = new TimeSlotsCollection();
        });

        it('sorts models chronologically by startDateTime', function() {
            collection.add([
                {startDateTime: '12/03/2014 00:00:00'},
                {startDateTime: '12/06/2014 00:00:00'},
                {startDateTime: '12/04/2014 00:00:00'},
            ]);

            expect(collection.at(0).get('startDateTime')).toEqual('12/03/2014 00:00:00');
            expect(collection.at(1).get('startDateTime')).toEqual('12/04/2014 00:00:00');
            expect(collection.at(2).get('startDateTime')).toEqual('12/06/2014 00:00:00');
        });

        it('parse the collection correctly', function() {
            var data = [
                {
                    appointmentTimeSlot: [
                        {
                            availability: true,
                            bookingStatus: '2',
                            endDateTime: '12/10/2016 08:30:00',
                            remainingAllowedOverBookings: '2',
                            startDateTime: '12/10/2016 08:00:00',
                        },
                        {
                            availability: true,
                            bookingStatus: '2',
                            endDateTime: '12/10/2016 09:00:00',
                            remainingAllowedOverBookings: '2',
                            startDateTime: '12/10/2016 08:30:00',
                        },
                    ],
                },
            ];
            collection.set(data, {parse: true});
            expect(collection.at(0).toJSON()).toEqual(data[0].appointmentTimeSlot[0]);
            expect(collection.at(1).toJSON()).toEqual(data[0].appointmentTimeSlot[1]);
        });
    });
});
